<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.client_projects.operations.menu', array( 'client_project' => $project), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.project-tasks.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.project_tasks.create', $project->id)); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
        <?php if(!is_null(Auth::getUser()->role_id) && config('global.can_see_all_records_role_id') == Auth::getUser()->role_id): ?>
            <?php if(Session::get('ProjectTask.filter', 'all') == 'my'): ?>
                <a href="?filter=all" class="btn btn-default">Show all records</a>
            <?php else: ?>
                <a href="?filter=my" class="btn btn-default">Filter my records</a>
            <?php endif; ?>
        <?php endif; ?>
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">
            <li><a href="<?php echo e(route('admin.project_tasks.index', $project->id)); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
            <span class="badge">  
             
              <?php echo e(\App\ProjectTask::where('project_id', $project->id)->count()); ?>

            


              </span>
            </a></li> 
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_delete')): ?>
            |
            <li><a href="<?php echo e(route('admin.project_tasks.index', $project->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>
            <span class="badge">
          <?php echo e(\App\ProjectTask::where('project_id', $project->id)->onlyTrashed()->count()); ?>



          </span>
            </a></li>
            <?php endif; ?>
        </ul>
    </p>
    
    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.name'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.priority'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.startdate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.duedate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.status'); ?></th>
                        <!--<th><?php echo app('translator')->getFromJson('global.project-tasks.fields.recurring'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.recurring-value'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.last-recurring-date'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.billable'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.hourly-rate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.milestone'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.project-tasks.fields.created-by'); ?></th>-->
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.project_tasks.mass_destroy', $project->id)); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.ajax = '<?php echo route('admin.project_tasks.index', $project->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptions.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project_task_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'name', name: 'name'},
                {data: 'priority.title', name: 'priority.title',searchable: false, sortable: false},
                {data: 'startdate', name: 'startdate'},
                {data: 'duedate', name: 'duedate'},
                {data: 'status.title', name: 'status.title',searchable: false, sortable: false},
                //{data: 'recurring.title', name: 'recurring.title'},
                //{data: 'recurring_value', name: 'recurring_value'},
                //{data: 'last_recurring_date', name: 'last_recurring_date'},
                //{data: 'billable', name: 'billable'},
                //{data: 'hourly_rate', name: 'hourly_rate'},
                //{data: 'milestone', name: 'milestone'},
                //{data: 'created_by.name', name: 'created_by.name'},
            
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>