<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo e($template->subject); ?>

    <?php echo $__env->make('admin.common.drop-down-menu', [
        'links' => [
            [
                'route' => 'admin.templates.edit', 
                'title' => trans('global.app_edit'), 
                'type' => 'edit',
                'icon' => '<i class="fa fa-pencil-square-o" style="margin-right: 15px;"></i>',
                'permission_key' => 'template_edit',
            ], 
            [
                'route' => 'admin.templates.destroy', 
                'title' => trans('global.app_delete'), 
                'type' => 'delete',
                'icon' => '<i class="fa fa-trash-o" style="margin-right: 5px;color:#ff0000;padding-left: 20px;"></i>',
                'redirect_url' => url()->previous(),
                'permission_key' => 'template_delete',
            ],
        ],
        'record' => $template,
        ] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </h3>

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_view'); ?>
        </div>

        <div class="panel-body table-responsive">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.key'); ?></th>
                            <td field-key='key'><?php echo e($template->key); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.type'); ?></th>
                            <td field-key='type'><?php echo e($template->type); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.subject'); ?></th>
                            <td field-key='subject'><?php echo e($template->subject); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.from-email'); ?></th>
                            <td field-key='from_email'><?php echo e($template->from_email); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.from-name'); ?></th>
                            <td field-key='from_name'><?php echo e($template->from_name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('templates::global.templates.fields.content'); ?></th>
                            <td field-key='content'><?php echo clean($template->content); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.templates.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>