<?php $request = app('Illuminate\Http\Request'); ?>



<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-10">
            <h2 style="margin-top: 0;"><?php echo e($reportTitle); ?></h2>

            <form action="" method="get" id="reportform">
            <div class="row">
                <div class="col-md-5">
                    <input type="text" class="form-control" name="date_filter" id="date_filter"/>
                </div>
                <div class="col-md-5">
                    <?php
                    $date_type = $request->input('date_type');
                    if ( empty( $date_type )) {
                        $date_type = 'created_at';
                    }
                    ?>

                    <?php if( ! empty( $dateTypes ) ): ?>
                    <select name="date_type" class="form-control" id="date_type">
                        <?php $__currentLoopData = $dateTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php if ( $key == $date_type ) echo ' selected' ?>><?php echo e($val); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php endif; ?>
                </div>
               
            </div>
            </form>
            <?php
            $controller = getController('controller');
            $action = getController('action');
            if ( 'ReportsController' === $controller && 'rolesUsersReport' === $action ) {
                $count = \App\Role::where('type', 'role')->whereBetween('created_at', [$date_from, $date_to])->get()->count();
                if ( $count == 0 ) {
                    echo  '<span style="color:red">'.trans("others.reports.users-count").'</span>';
                }
            }
            ?>

            <canvas id="myChart"></canvas>

            <script src="<?php echo e(url('js/cdn-js-files/chartjs250')); ?>/Chart.min.js"></script>
            
            <script>
                window.chartColors = {
                    red: 'rgb(255, 99, 132)',
                    orange: 'rgb(255, 159, 64)',
                    yellow: 'rgb(255, 205, 86)',
                    green: 'rgb(75, 192, 192)',
                    blue: 'rgb(54, 162, 235)',
                    purple: 'rgb(153, 102, 255)',
                    grey: 'rgb(201, 203, 207)'
                };

                var color = Chart.helpers.color;

                var ctx = document.getElementById("myChart");
                var myChart = new Chart(ctx, {
                    type: '<?php echo e($chartType); ?>',
                    data: {
                        labels: [
                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                "<?php echo e($group); ?>",
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],

                        datasets: [{
                            label: '<?php echo e($reportLabel); ?>',
                            data: [
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo clean($result); ?>,
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            ],
                            <?php if( ! empty( $colors ) ): ?>
                            backgroundColor: [
                                <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                "<?php echo e($color); ?>",
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            ],
                            <?php else: ?>
                            backgroundColor: color(window.chartColors.blue).alpha(0.5).rgbString(),
                            <?php endif; ?>
                            borderWidth: 1
                        }]
                    },
                    <?php if( ! in_array( $chartType, ['pie'] ) ): ?>
                    options: {
                        scales: {
                            xAxes: [],
                            yAxes: [{
                                ticks: {
                                    beginAtZero:true
                                }
                            }]
                        }
                    }
                    <?php endif; ?>
                });
            </script>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <!-- Include Required Prerequisites -->
<script src="<?php echo e(url('js/cdn-js-files')); ?>/moment.min.js"></script>

<!-- Include Date Range Picker -->
<script src="<?php echo e(url('js/cdn-js-files/daterangepicker')); ?>/daterangepicker.js"></script>

<link href="<?php echo e(url('css/cdn-styles-css/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet">


    <script type="text/javascript">
        $(function () {
            let dateInterval = getQueryParameter('date_filter');
            let start = moment().startOf('isoWeek');
            let end = moment().endOf('isoWeek');
            if (dateInterval) {
                dateInterval = dateInterval.split(' - ');
                start = dateInterval[0];
                end = dateInterval[1];
            }
            $('#date_filter').daterangepicker({
                "showDropdowns": true,
                "showWeekNumbers": true,
                "alwaysShowCalendars": true,
                startDate: start,
                endDate: end,
                locale: {
                    format: '<?php echo e(config('app.date_format_moment')); ?>',
                    firstDay: 1,
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                    'All time': [moment().subtract(30, 'year').startOf('month'), moment().endOf('month')],
                }
            });
        });

        $('#date_filter').on('apply.daterangepicker', function(ev, picker) {
            $('#reportform').submit();
        });

        $('#date_type').change(function() {
            $('#reportform').submit();
        });

        function getQueryParameter(name) {
            const url = window.location.href;
            name = name.replace(/[\[\]]/g, "\\$&");
            const regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>