<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
<?php echo $__env->make('admin.client_projects.operations.menu', array('client_project' => $project), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.client-projects.invoice-project'); ?>
        </div>

        <div class="panel-body table-responsive">
            <div class="row">
                <?php echo Form::open(['method' => 'POST', 'route' => ['admin.client_projects.invoice-project-preview', $project->id],'class'=>'formvalidation']); ?>

                <div class="col-xs-12 form-group">
                    <?php echo Form::label('invoice_data_type', trans('global.client-projects.invoice-data-type').'*', ['class' => 'control-label']); ?>

                    <p class="help-block"></p><br/>
                    <?php if($errors->has('invoice_data_type')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_data_type')); ?>

                        </p>
                    <?php endif; ?>
                    <div class="col-xs-3 well-note">
                        <label>
                            <?php
                            $disabled = '';
                            if ( in_array($project->billing_type_id, [ PROJECT_BILLING_TYPE_TASK_HOURS, PROJECT_BILLING_TYPE_PROJECT_HOURS]) ) {
                                $disabled = ' disabled = ""';
                            }
                            ?>
                            <?php echo Form::radio('invoice_data_type', 'single_line', false, ['required' => '', $disabled ]); ?>

                            Single line  [ Fixed Rate ]<?php echo digi_get_help( trans( 'global.client-projects.single_line_help' ) ); ?>

                        </label>
                    </div>
                    <div class="col-xs-3 well-note">
                        <label>
                            <?php
                            $disabled = '';
                            if ( $project->billing_type_id == PROJECT_BILLING_TYPE_FIXED_PRICE ) {
                                $disabled = ' disabled';
                            }
                            
                            ?>
                            <?php echo Form::radio('invoice_data_type', 'task_per_item', false, ['required' => '', $disabled]); ?>

                            Task per item<?php echo digi_get_help( trans( 'global.client-projects.task_per_item_help' ) ); ?>

                        </label>
                    </div>

                    <div class="col-xs-3 well-note2">
                        <label>
                            <?php
                            $disabled = '';
                            if ( $project->billing_type_id == PROJECT_BILLING_TYPE_FIXED_PRICE ) {
                                $disabled = ' disabled = ""';
                            }
                            ?>
                            <?php echo Form::radio('invoice_data_type', 'timesheets_include_notes', false, ['required' => '', $disabled]); ?>

                            Include each timesheet note in item description<?php echo digi_get_help( trans( 'global.client-projects.timesheets_include_notes_help' ) ); ?>

                        </label>
                    </div>
                    
                </div>


                

                <?php if( $tasks->count() > 0 ): ?>
                    <div class="col-xs-12 form-group">
                        <?php echo Form::checkbox('select_all_tasks', 1, old('select_all_tasks', false), ['id' => 'select_all_tasks']); ?>

                        <?php echo Form::label('select_all_tasks', trans('global.client-projects.select-all-tasks'), ['class' => 'control-label']); ?>

                    </div><br/>
                    <div class="col-xs-12" >
                    <div class="colxs10" >
                    <div class="row">
                        <div style="border: 2px solid whitesmoke;" class="col-xs-3 well-note1 text-center"><strong><?php echo app('translator')->getFromJson('global.project-tasks.title'); ?></strong></div>
                        <div style="border: 2px solid whitesmoke;" class="col-xs-3 well-note1 text-center"><strong><?php echo app('translator')->getFromJson('global.project-tasks.fields.status'); ?></strong></div>
                        <div style="border: 2px solid whitesmoke;" class="col-xs-3 well-note1 text-center"><strong><?php echo app('translator')->getFromJson('global.project-tasks.timer'); ?></strong></div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                        
                    <div class="col-xs-12">
                        
                        <div class="col-xs-3 colxs3" style="text-align: left;">
                            <?php echo Form::checkbox('tasks[]', $task->id, old('tasks', false), ['id' => 'task_' . $task->id, 'class' => 'task']); ?>

                            <?php echo Form::label('task_' . $task->id, $task->name, ['class' => 'control-label' ]); ?>

                            <?php
                            $status_color = $task->task_status->color;
                            if ( empty( $status_color ) ) {
                                $status_color = 'red';
                            }
                            ?>                            
                        </div>
                        
                        <div class="col-xs-3 colxs3" style="text-align: center;">
                            <small class="hgt6"><span class="label" style="border: 1px solid <?php echo e($status_color); ?>;color:<?php echo e($status_color); ?>;"><?php echo e($task->status ? $task->task_status->title : 'N/A'); ?></span></small>
                        </div>
                        <div class="col-xs-3 colxs3" style="text-align: center;">
                            <small class="tesfhhhh">
                            <?php
                            $timer = \App\TimeEntry::where('task_id', $task->id)->first();
                            if ( $timer ) {
                                $running_timer = \App\TimeEntry::where('task_id', $task->id)->whereNull('end_date')->first();
                                if ( $running_timer ) {
                                    echo '<span class="text-info">' . trans('global.project-tasks.running-timer') . '</span>';
                                } else {

                                }
                            } else {
                                echo '<span class="text-danger">' . trans('global.project-tasks.no-timers') . '</span>';
                            }
                            ?>
                            </small>
                           </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                
                <?php endif; ?>

                <div class="row">
                    <div class="col-xs-12">    

                <?php if( $expenses->count() > 0 ): ?>
                    <div class="col-xs-12" style="margin-top: 15px;">
                        <?php echo Form::checkbox('select_all_expenses', 0, old('select_all_expenses', false), ['id' => 'select_all_expenses']); ?>

                        <?php echo Form::label('select_all_expenses', trans('global.client-projects.select-all-expenses'), ['class' => 'control-label']); ?>

                    </div>
                    <div class="col-xs-12">
                    <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xs-6">
                            <?php echo Form::checkbox('expenses[]', $expense->id, old('expenses', false), ['id' => 'expense_' . $expense->id, 'class' => 'expense']); ?>

                            <?php echo Form::label('expense_' . $expense->id, $expense->name, ['class' => 'control-label']); ?>                            
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                     <div class="col-xs-6 form-group" style="margin-left: -25px;">
                <p class="text-danger"><?php echo app('translator')->getFromJson('global.client-projects.marked-as-complete'); ?></p>

                </div>
            </div>
                    </div>
                    </div>
                <?php endif; ?>

               
                </div>  
            </div>

        </div>
        <div class="col-xs-12 form-group">
               
                <?php echo Form::submit(trans('global.app_create'), ['class' => 'btn btn-danger wave-effect']); ?>

                <?php echo Form::close(); ?>  
                </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    <script>
        
        $('#select_all_tasks').click(function() {
            if ( $('#select_all_tasks').is(':checked') ) {
                $('.task').prop('checked', true);
            } else {
                $('.task').prop('checked', false);
            }
        });

        $('#select_all_expenses').click(function() {
            if ( $('#select_all_expenses').is(':checked') ) {
                $('.expense').prop('checked', true);
            } else {
                $('.expense').prop('checked', false);
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>