<?php $__env->startSection('content'); ?>
    <h3 class="page-title">Monthly report</h3>

    <?php echo Form::open(['method' => 'get']); ?>

        <div class="row">
            <div class="col-xs-2 col-md-2" style="margin-left:15px;">
            <div class="form-group">
                <?php echo Form::label('year','Year',['class' => 'control-label']); ?>

                <?php echo Form::select('y', array_combine(range(date("Y"), 1900), range(date("Y"), 1900)), old('y', Request::get('y', date('Y'))), ['class' => 'form-control', 'data-live-search' => 'true', 'data-show-subtext' => 'true']); ?>

            </div>
        </div>
            <div class="col-xs-2 col-md-2">
            <div class="form-group">
                <?php echo Form::label('month','Month',['class' => 'control-label']); ?>

                <?php echo Form::select('m', cal_info(0)['months'], old('m', Request::get('m', date('m'))), ['class' => 'form-control', 'data-live-search' => 'true', 'data-show-subtext' => 'true']); ?>

            </div>
        </div>
            <div class="col-xs-4 col-md-4" style="padding-top:6px;"><br/>
                <label class="control-label">&nbsp;</label>
                <?php echo Form::submit('View Report',['class' => 'btn btn-primary']); ?>

            </div>
        </div>
        <br/>

    <div class="col-md-8">
    <div class="panel panel-default">
        <div class="panel-heading">
            Report
        </div>
        <?php echo Form::close(); ?>

        <div class="panel-body">
            <div class="row">
                <div class="col-md-4">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th>Income</th>
                            <td><?php echo e(digiCurrency($inc_total)); ?></td>
                        </tr>
                        <tr>
                            <th>Expenses</th>
                            <td><?php echo e(digiCurrency($exp_total)); ?></td>
                        </tr>
                        <tr>
                            <th>Profit</th>
                            <td><?php echo e(digiCurrency($profit)); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-4">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th>Income by category</th>
                            <th><?php echo e(digiCurrency($inc_total)); ?></th>
                        </tr>
                    <?php $__currentLoopData = $inc_summary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th><?php echo e($inc['name']); ?></th>
                            <td><?php echo e(digiCurrency($inc['amount'])); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
                <div class="col-md-4">
                    <table class="table table-bordered table-striped">
                        <tr>
                            <th>Expenses by category</th>
                            <th><?php echo e(digiCurrency($exp_total)); ?></th>
                        </tr>
                    <?php $__currentLoopData = $exp_summary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <th><?php echo e($inc['name']); ?></th>
                            <td><?php echo e(digiCurrency($inc['amount'])); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
    
    <?php echo $__env->make('admin.monthly_reports.graph', compact( 'reportTitle', 'results', 'chartType', 'reportLabel', 'reportTitle_expense', 'results_expense', 'chartType_expense', 'reportLabel_expense' ) , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>