<h3 class="page-title"><?php echo app('translator')->getFromJson('global.income-category.title'); ?></h3>
<?php echo Form::open(['method' => 'POST', 'route' => ['admin.income_categories.store'],'class'=>'formvalidation', 'id' => 'frmIncomeCategories']); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <?php echo app('translator')->getFromJson('global.app_create'); ?>
    </div>

    <div class="alert message_bag" style="display:none">
        <ul></ul>
    </div>
    
    <div class="panel-body">
        <div class="row">
            <div class="col-xs-4">
            <div class="form-group">
                <?php echo Form::label('name', trans('global.income-category.fields.name').'*', ['class' => 'control-label form-label']); ?>

                <div class="form-line">
                <?php echo Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => 'Name', 'required' => '']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('name')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('name')); ?>

                    </p>
                <?php endif; ?>
            </div>
            </div>
            </div>
        </div>
        
    </div>
</div>

<?php
if ( empty( $is_ajax ) ) {
  $is_ajax = 'no';
}
?>
<input type="hidden" name="is_ajax" value="<?php echo e($is_ajax); ?>">
<?php
if ( empty( $selectedid ) ) {
  $selectedid = 'income_category_id';
}
?>
<input type="hidden" name="selectedid" value="<?php echo e($selectedid); ?>">

<?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect saveButtonIncomeCategories']); ?>

<?php echo Form::close(); ?>


<?php if( ! empty( $is_ajax ) && 'yes' === $is_ajax ): ?>
<script type="text/javascript">
  $(".saveButtonIncomeCategories").click(function(e){
            e.preventDefault();

            $.ajax({
                url: "<?php echo e(route('admin.income_categories.store')); ?>",
                type:'POST',
                data: $( '#frmIncomeCategories' ).serializeArray(),
                success: function(data) {
                    if($.isEmptyObject(data.error)){
                        notifyMe('success', data.success);
                        $('#loadingModal').modal('hide');

                        var value = data.record.id;
                        var title = data.record.name;
                        $('#' + data.record.selectedid).append('<option value="'+value+'" selected="selected">'+title+'</option>');
                    }else{
                        printErrorMsg(data.error);
                    }
                }
            });
  });

  function printErrorMsg (msg) {
      $(".message_bag").find("ul").html('');
      $(".message_bag").css('display','block');
      $(".message_bag").addClass('alert-danger');
      $.each( msg, function( key, value ) {
          $(".message_bag").find("ul").append('<li>'+value+'</li>');
      });
  }
</script>
<?php endif; ?>
