<div class="row white-bg page-heading">

    <div class="col-lg-12">
        
        <div class="title-action">

            <a href="<?php echo e(route('admin.recurring_invoices.show', $invoice->id)); ?>" class="btn btn-primary ml-sm no-shadow no-border"><i class="fa fa-long-arrow-left"></i> <?php echo app('translator')->getFromJson('custom.invoices.app_back_to_recurring_invoice'); ?></a>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_edit')): ?>
            <a href="<?php echo e(route('admin.recurring_invoices.edit', $invoice->id)); ?>" class="btn btn-primary"><i class="fa fa-pencil-square-o"></i><?php echo e(trans('custom.invoices.recurring-edit')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_changestatus_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-success mb-1 btn-min-width dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-arrows-v" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.mark-as')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_changestatus_paid')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.changestatus', [ 'id' => $invoice->id, 'status' => 'paid'])); ?>"><?php echo e(trans('custom.invoices.paid')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_changestatus_due')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.changestatus', [ 'id' => $invoice->id, 'status' => 'due'])); ?>"><?php echo e(trans('custom.invoices.due')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_changestatus_partial')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.changestatus', [ 'id' => $invoice->id, 'status' => 'partial'])); ?>"><?php echo e(trans('custom.invoices.partial')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_changestatus_cancelled')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.changestatus', [ 'id' => $invoice->id, 'status' => 'cancelled'])); ?>"><?php echo e(trans('custom.invoices.cancelled')); ?></a></li>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_preview')): ?>
            <a href="<?php echo e(route( 'admin.recurring_invoices.preview', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info"><i class="fa fa-street-view"></i><?php echo e(trans('custom.common.preview')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_duplicate')): ?>
            <a href="<?php echo e(route( 'admin.recurring_invoices.duplicate', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-info"><i class="fa fa-clone"></i> <?php echo e(trans('custom.common.duplicate')); ?></a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_uploads')): ?>
            <a href="<?php echo e(route( 'admin.recurring_invoices.upload', [ 'slug' => $invoice->slug ] )); ?>" class="btn btn-success" title="<?php echo e(trans('custom.invoices.upload-documents')); ?>">                                
                <i class="fa fa-upload" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.invoices.upload-documents')); ?>

            </a>
            <?php endif; ?>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_pdf_access')): ?>
            <div class="btn-group ">
                <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">                                    
                    <i class="fa fa-file-pdf-o" aria-hidden="true"></i>&nbsp;<?php echo e(trans('custom.common.pdf')); ?>&nbsp;<span class="caret"></span>
                </button>
                <div class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_pdf_view')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.invoicepdf', ['slug' => $invoice->slug, 'operation' => 'view'] )); ?>"><?php echo e(trans('custom.common.view-pdf')); ?></a></li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_pdf_download')): ?>
                    <li><a class="dropdown-item" href="<?php echo e(route('admin.recurring_invoices.invoicepdf', $invoice->slug)); ?>"><?php echo e(trans('custom.common.download-pdf')); ?></a></li>
                    <?php endif; ?>

                </div>
            </div>
            <?php endif; ?>

             <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('recurring_invoice_print')): ?>
            <a href="javascript:void(0);" class="btn btn-large btn-primary buttons-print ml-sm" onclick="printItem('invoice_pdf')" title="<?php echo e(trans('custom.common.print')); ?>"><i class="fa fa-print" aria-hidden="true"></i> <?php echo app('translator')->getFromJson('custom.common.print'); ?></a>
            <?php endif; ?>
            </div>
        </div>
</div>