<?php $__env->startSection('content'); ?>
   <h3 class="page-title"><?php echo app('translator')->getFromJson('global.dashboard-widgets.title'); ?></h3>
	<?php if( $widget ): ?>
	<?php echo Form::model($widget, ['method' => 'POST', 'route' => ['admin.home.dashboard-widgets-store', $widget->id],'class'=>'formvalidation', 'id' => 'frmAccount']); ?>

	<?php else: ?>
	<?php echo Form::open(['method' => 'POST', 'route' => ['admin.home.dashboard-widgets-store'],'class'=>'formvalidation', 'id' => 'frmAccount']); ?>

	<?php endif; ?>

	<div class="panel panel-default">
	    <div class="panel-heading">
	        <?php if( $widget ): ?>
	        	<?php echo app('translator')->getFromJson('global.app_edit'); ?>
	        <?php else: ?>
	        	<?php echo app('translator')->getFromJson('global.app_create'); ?>
	        <?php endif; ?>
	    </div>


	    
	    <div class="panel-body">
	        <div class="row">
	            <div class="col-xs-<?php echo e(COLUMNS); ?>">
	            <div class="form-group">
	                <?php echo Form::label('title', trans('global.dashboard-widgets.fields.title').'*', ['class' => 'control-label form-label']); ?>

	                <div class="form-line">
	                <?php echo Form::text('title', old('title'), ['class' => 'form-control', 'placeholder' => 'Name', 'required' => '']); ?>

	                <p class="help-block"></p>
	                <?php if($errors->has('title')): ?>
	                    <p class="help-block">
	                        <?php echo e($errors->first('title')); ?>

	                    </p>
	                <?php endif; ?>
	            </div>
	            </div>
	            </div>

	             <div class="col-xs-<?php echo e(COLUMNS); ?>">
	            <div class="form-group">
	                <?php echo Form::label('slug', trans('global.dashboard-widgets.fields.slug').'', ['class' => 'control-label']); ?>

	                <?php echo Form::text('slug', old('slug'), ['class' => 'form-control', 'placeholder' => trans('global.dashboard-widgets.fields.slug')]); ?>

	                <p class="help-block"></p>
	                <?php if($errors->has('slug')): ?>
	                    <p class="help-block">
	                        <?php echo e($errors->first('slug')); ?>

	                    </p>
	                <?php endif; ?>
	            </div>
	            </div>

	            <div class="col-xs-<?php echo e(COLUMNS); ?>">
	            <div class="form-group">
	                <?php echo Form::label('status', trans('global.dashboard-widgets.fields.status').'', ['class' => 'control-label form-label']); ?>

	                <div class="form-line">
	                
	                <?php
	                $statuses = [
	                	'active' => trans('global.dashboard-widgets.active'),
	                	'inactive' => trans('global.dashboard-widgets.inactive'),
	                ];
	                ?>
	                <?php echo Form::select('status', $statuses, old('status'), ['class' => 'form-control select2', 'required' => '']); ?>

	                
	                <p class="help-block"></p>
	                <?php if($errors->has('status')): ?>
	                    <p class="help-block">
	                        <?php echo e($errors->first('status')); ?>

	                    </p>
	                <?php endif; ?>
	            </div>
	            </div>
	            </div>
	     
	       
	            <div class="col-xs-<?php echo e(COLUMNS); ?>">
	            <div class="form-group">
	                <?php echo Form::label('type', trans('global.dashboard-widgets.fields.type').'', ['class' => 'control-label form-label']); ?>

	                <div class="form-line">
	                <?php
	                $statuses = [
	                	'numbers' => trans('global.dashboard-widgets.numbers'),
	                	'chart' => trans('global.dashboard-widgets.chart'),
	                	'list' => trans('global.dashboard-widgets.list'),
	                	'view' => trans('global.app_view'),
	                ];
	                ?>
	                <?php echo Form::select('type', $statuses, old('type'), ['class' => 'form-control select2', 'required' => '']); ?>

	                <p class="help-block"></p>
	                <?php if($errors->has('type')): ?>
	                    <p class="help-block">
	                        <?php echo e($errors->first('type')); ?>

	                    </p>
	                <?php endif; ?>
	            </div>
	            </div>
	            </div>

	            <div class="col-xs-<?php echo e(COLUMNS); ?>">
	            <div class="form-group">
	                <?php echo Form::label('columns', trans('global.dashboard-widgets.fields.columns').'', ['class' => 'control-label form-label']); ?>

	                <div class="form-line">
	                <?php
	                $columns = [
	                	2 => 2, 
	                	4 => 4, 
	                	6 => 6, 
	                	8 => 8, 
	                	10 => 10, 
	                	12 => 12,
	                ];
	                ?>
	                <?php echo Form::select('columns', $columns, old('columns'), ['class' => 'form-control select2', 'required' => '']); ?>

	                <p class="help-block"></p>
	                <?php if($errors->has('columns')): ?>
	                    <p class="help-block">
	                        <?php echo e($errors->first('columns')); ?>

	                    </p>
	                <?php endif; ?>
	            </div>
	            </div>
	            </div>


	           
	      
	            
	        </div>
	        
	    </div>
	</div>
	<?php
	if ( empty( $is_ajax ) ) {
	    $is_ajax = 'no';
	}
	?>
	<input type="hidden" name="is_ajax" value="<?php echo e($is_ajax); ?>">
	<?php
	if ( empty( $selectedid ) ) {
	    $selectedid = 'account_id';
	}
	?>
	<input type="hidden" name="selectedid" value="<?php echo e($selectedid); ?>">
	<?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect saveAccount']); ?>

	<?php echo Form::close(); ?>


	<?php if( 'yes' === $is_ajax ): ?>
	<script type="text/javascript">
	  $(".saveAccount").click(function(e){
	            e.preventDefault();

	            $.ajax({
	                url: "<?php echo e(route('admin.accounts.store')); ?>",
	                type:'POST',
	                data: $( '#frmAccount' ).serializeArray(),
	                success: function(data) {
	                    if($.isEmptyObject(data.error)){
	                        notifyMe('success', data.success);
	                        $('#loadingModal').modal('hide');

	                        var value = data.record.id;
	                        var title = data.record.name;
	                        $('#' + data.record.selectedid).append('<option value="'+value+'" selected="selected">'+title+'</option>');                        
	                    }else{
	                        printErrorMsg(data.error);
	                    }
	                }
	            });
	  });

	  function printErrorMsg (msg) {
	      $("#message_bag").find("ul").html('');
	      $("#message_bag").css('display','block');
	      $("#message_bag").addClass('alert-danger');
	      $.each( msg, function( key, value ) {
	          $("#message_bag").find("ul").append('<li>'+value+'</li>');
	      });
	  }
	</script>
	<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>