<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    
    <?php echo $__env->make('admin.client_projects.operations.menu', array( 'client_project' => $project), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>

    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.mile-stones.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.mile_stones.create', $project->id)); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    <p>
        <ul class="list-inline">

            <li><a href="<?php echo e(route('admin.mile_stones.index', $project->id)); ?>" style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?>
                 <span class="badge">  

              <?php echo e(\App\MileStone::where('project_id', $project->id)->count()); ?>

                            
              </span>
            </a></li>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_delete')): ?> |
            <li><a href="<?php echo e(route('admin.mile_stones.index', $project->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>
            <span class="badge">
         
          <?php echo e(\App\MileStone::where('project_id', $project->id)->onlyTrashed()->count()); ?>

         
          </span>
            </a></li>
            <?php endif; ?>
        </ul>
    </p>
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.mile-stones.fields.name'); ?></th>
                        
                        <th><?php echo app('translator')->getFromJson('global.mile-stones.fields.description-visible-to-customer'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.mile-stones.fields.due-date'); ?></th>
                        
                        <th><?php echo app('translator')->getFromJson('global.mile-stones.fields.milestone-order'); ?></th>
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.mile_stones.mass_destroy', $project->id)); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptions.ajax = '<?php echo route('admin.mile_stones.index', $project->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptions.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mile_stone_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'name', name: 'name'},
                
                {data: 'description_visible_to_customer', name: 'description_visible_to_customer'},
                {data: 'due_date', name: 'due_date'},
                
                {data: 'milestone_order', name: 'milestone_order'},
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTables();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>