<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('quotes::custom.quotes.title'); ?></h3>
    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.quotes.store'],'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_create'); ?>
        </div>
        <?php
        if ( empty( $fetchaddress ) ) {
            $fetchaddress = 'no';
        }
        ?>
        <input type="hidden" name="fetchaddress" id="fetchaddress" value="<?php echo e($fetchaddress); ?>">
        <?php
        if ( empty( $selectedid ) ) {
            $selectedid = 'customer_id';
        }
        ?>
        <input type="hidden" name="selectedid" id="selectedid" value="<?php echo e($selectedid); ?>">
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('customer_id', trans('global.quotes.fields.customer').'', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('customer_create') ): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createcustomer" data-selectedid="customer_id" data-redirect="<?php echo e(route('admin.quotes.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.customer') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="createcustomer" data-selectedid="customer_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.customer') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('customer_id', $customers, old('customer_id'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true','required' => '', 'id' => 'customer_id']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('customer_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('customer_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('currency_id', trans('global.quotes.fields.currency').'*', ['class' => 'control-label']); ?>

               <?php
                $currency_id = ! empty( old('currency_id_old') ) ? old('currency_id_old') : '';
                if ( empty( $currency_id ) && ! empty( $invoice ) ) {
                $currency_id = $invoice->currency_id;
                }
              ?>
                    <?php echo Form::select('currency_id', $currencies, old('currency_id',$currency_id), ['class' => 'form-control', 'required' => '','data-live-search' => 'true','data-show-subtext' => 'true','disabled' =>'']); ?>

                <input type="hidden" name="currency_id_old" id="currency_id_old" value="<?php echo e($currency_id); ?>">
                    <p class="help-block"></p>
                    <?php if($errors->has('currency_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('currency_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('status', trans('global.quotes.fields.status').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('status', $enum_status, old('status'), ['class' => 'form-control select2']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('status')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('status')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('sale_agent', trans('global.invoices.fields.sale-agent').'*', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('customer_create') ): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="sale_agent" data-selectedid="sale_agent" data-redirect="<?php echo e(route('admin.invoices.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.sale-agent') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="sale_agent" data-selectedid="sale_agent" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.sale-agent') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('sale_agent', $sales_agent, old('sale_agent'), ['class' => 'form-control select2', 'required' => '', 'data-live-search' => 'true', 'data-show-subtext' => 'true', 'id' => 'sale_agent']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('sale_agent')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('sale_agent')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                       
                    <?php echo Form::label('address', trans('global.invoices.fields.address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('address', old('address'), ['class' => 'form-control ', 'placeholder' => trans('global.invoices.selected-customer-address'), 'rows' => 4, 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                       
                    <?php echo Form::label('delivery_address', trans('global.invoices.fields.delivery-address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('delivery_address', old('delivery_address'), ['class' => 'form-control ', 'placeholder' => trans('global.invoices.selected-customer-delivery-address'), 'rows' => 4, 'id' => 'delivery_address']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('delivery_address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('delivery_address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('show_delivery_address', trans('global.quotes.fields.show-delivery-address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('show_delivery_address', yesnooptions(), old('show_delivery_address'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('show_delivery_address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('show_delivery_address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('title', trans('global.quotes.fields.title'), ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('title', old('title'), ['class' => 'form-control', 'placeholder' => 'Title']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('title')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('title')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            </div>
           
                
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('invoice_prefix', trans('global.quotes.fields.quote-prefix').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php
                    $invoice_prefix = getSetting( 'quote-prefix', 'quote-settings' );
                    ?>
                    <?php echo Form::text('invoice_prefix', old('invoice_prefix', $invoice_prefix), ['class' => 'form-control', 'placeholder' => trans('global.quotes.fields.quote-prefix')]); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_prefix')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_prefix')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
            </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('show_quantity_as', trans('global.quotes.fields.show-quantity-as').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php
                    $show_quantity_as = getSetting( 'show_quantity_as', 'quote-settings' );
                    ?>
                    <?php echo Form::text('show_quantity_as', old('show_quantity_as', $show_quantity_as), ['class' => 'form-control', 'placeholder' => 'Show Quantity As']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('show_quantity_as')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('show_quantity_as')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('invoice_no', trans('global.quotes.fields.quote-no'), ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php
                    $invoice_no = getNextNumber('Quote');
                    if ( ! empty( $invoice ) ) {
                        $invoice_no = $invoice->invoice_no;
                    }
                    ?>                    
                    <?php echo Form::text('invoice_no', old('invoice_no', $invoice_no), ['class' => 'form-control', 'placeholder' => 'Enter Quote number']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_no')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_no')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>
            
                
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                   
                    <?php echo Form::label('reference', trans('global.quotes.fields.reference').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('reference', old('reference'), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('reference')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('reference')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>

            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('invoice_date', trans('global.quotes.fields.quote-date').'', ['class' => 'control-label form-label']); ?>

                    <?php
                    $invoice_date = digiTodayDateAdd();
                    ?>
                    <div class="form-line">
                    <?php echo Form::text('invoice_date', old('invoice_date', $invoice_date), ['class' => 'form-control date', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('invoice_due_date', trans('global.quotes.fields.quote-expiry-date').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php
                    $invoice_due_after = getSetting( 'quote_due_after', 'quote-settings', 2 );
                    ?>  
                    <?php echo Form::text('invoice_due_date', old('invoice_due_date', digiTodayDateAdd($invoice_due_after)), ['class' => 'form-control date', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_due_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_due_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>
                <?php if( isPluginActive('product') ): ?> 
                <?php
                $enable_products_slider = getSetting( 'enable_products_slider', 'site_settings' );
                if ( 'yes' === $enable_products_slider ) {
                    ?>
                    <div class="col-xs-12">
                        <div class="form-group productsslider" style="display: none;">
                        <?php echo $__env->make('admin.common.products-slider', compact('products_return'), \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        </div>
                        <span id="productsslider_loader" style="display: block;">
                            <img src="<?php echo e(asset('images/loading-small.gif')); ?>"/>
                        </span>
                    </div>
                    <?php
                }
                ?>
                <div class="col-xs-12">
                    <div class="productsrow">
                        <?php echo $__env->make('admin.common.add-products', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    </div>
                </div>
            <?php else: ?>
            <div class="col-xs-8">
            <div class="form-group">      
            <?php echo Form::label('amount', trans('global.invoices.fields.amount') . '*', ['class' => 'control-label']); ?>

            <div class="form-line">
            <?php echo Form::number('amount', old('amount'), ['class' => 'form-control', 'placeholder' => 'amount', 'step' => '0.01', 'required' => true]); ?>

            <p class="help-block"></p>
            <?php if($errors->has('amount')): ?>
                <p class="help-block">
                    <?php echo e($errors->first('amount')); ?>

                </p>
            <?php endif; ?>
                </div>
            </div>
                </div>
                <?php endif; ?>
                <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('invoice_notes', trans('global.quotes.fields.client-notes').'', ['class' => 'control-label']); ?>

                    <?php
                    $predefined_clientnote_invoice = getSetting( 'predefined_clientnote_quote', 'quote-settings' );
                    ?>
                    <?php echo Form::textarea('invoice_notes', old('invoice_notes', $predefined_clientnote_invoice), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_notes')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_notes')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('admin_notes', trans('global.invoices.fields.admin-notes').'', ['class' => 'control-label']); ?>

                    <?php
                    $predefined_adminnote_quote = getSetting( 'predefined_adminnote_quote', 'quote-settings' );
                    ?>
                    <?php echo Form::textarea('admin_notes', old('admin_notes', $predefined_adminnote_quote), ['class' => 'form-control', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('admin_notes')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('admin_notes')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-12">
                <div class="form-group">
                    <?php echo Form::label('terms_conditions', trans('global.invoices.fields.terms-conditions').'', ['class' => 'control-label']); ?>

                    <?php
                    $predefined_terms_invoice = getSetting( 'predefined_terms_quote', 'quote-settings' );
                    ?>
                    <?php echo Form::textarea('terms_conditions', old('terms_conditions', $predefined_terms_invoice), ['class' => 'form-control editor', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('terms_conditions')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('terms_conditions')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('tax_id', trans('global.quotes.fields.tax').'', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('tax_create') ): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createtax" data-selectedid="tax_id" data-redirect="<?php echo e(route('admin.products.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.tax') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="createtax" data-selectedid="tax_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.tax') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('tax_id', $taxes, old('tax_id'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('tax_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('tax_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
				
				<?php
				$enum_tax_format = [
					"after_tax" => "Tax After Product Tax", 
					"before_tax" => "Tax Before Product Tax",
				];
				?>
				<div class="col-xs-<?php echo e(COLUMNS); ?>">
						<div class="form-group">
						<?php echo Form::label('tax_format', trans('global.invoices.fields.tax_format').'', ['class' => 'control-label']); ?>

						<?php echo Form::select('tax_format', $enum_tax_format, '', ['class' => 'form-control select2']); ?>

					</div>
				</div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                       
                    <?php echo Form::label('discount_id', trans('global.quotes.fields.discount').'', ['class' => 'control-label']); ?>

                    <?php if( Gate::allows('discount_create') ): ?>
                        <?php if( 'button' === $addnew_type ): ?>
                        &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="creatediscount" data-selectedid="discount_id" data-redirect="<?php echo e(route('admin.products.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.discount') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                        <?php else: ?>        
                        &nbsp;<a class="modalForm" data-action="creatediscount" data-selectedid="discount_id" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo e(trans('global.add_new_title', ['title' => strtolower( trans('global.quotes.fields.discount') )])); ?>"><i class="fa fa-plus-square"></i></a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php echo Form::select('discount_id', $discounts, old('discount_id'), ['class' => 'form-control select2']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('discount_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('discount_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
			
			<?php
			$enum_discounts_format = [
				"after_tax" => "Discount After Product Tax",
				"before_tax" => "Discount Before Product Tax",
			];
			?>
			<div class="col-xs-<?php echo e(COLUMNS); ?>">
					<div class="form-group">
                        
					<?php echo Form::label('discount_format', trans('global.invoices.fields.discount_format').'', ['class' => 'control-label']); ?>

					<?php echo Form::select('discount_format', $enum_discounts_format, '', ['class' => 'form-control select2']); ?>

				</div>
			</div>
        </div>

        <div class="row">
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                       
                    <?php echo Form::label('recurring_period_id', trans('quotes::custom.quotes.payment-terms').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('recurring_period_id', $recurring_periods, old('recurring_period_id'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('recurring_period_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('recurring_period_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
          
         
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect', 'name' => 'save']); ?>

    <?php echo Form::submit(trans('global.app_save_send'), ['class' => 'btn btn-success wave-effect', 'name' => 'savesend','value' => 'savesend']); ?>

    <?php echo Form::close(); ?>


    <?php echo $__env->make('admin.common.modal-loading-submit', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##

    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <?php echo $__env->make('admin.common.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('admin.common.modal-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>