

<?php $__env->startSection('content'); ?>
    <h3 class="page-subject"><?php echo app('translator')->getFromJson('contracts::custom.contracts.title'); ?></h3>
    
    <?php echo Form::model($recurring_invoice, ['method' => 'PUT', 'route' => ['admin.contracts.update', $recurring_invoice->id],'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_edit'); ?>
        </div>

        <div class="panel-body">
            <div class="row">
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('customer_id', trans('global.recurring-invoices.fields.customer').'', ['class' => 'control-label']); ?>

                    <?php if( 'button' === $addnew_type ): ?>
                    &nbsp;<button type="button" class="btn btn-danger modalForm" data-action="createcustomer" data-selectedid="customer_id" data-redirect="<?php echo e(route('admin.invoices.create')); ?>" data-toggle="tooltip" data-placement="bottom" data-original-subject="<?php echo e(trans('global.add_new_title', ['subject' => strtolower( trans('global.contracts.fields.customer') )])); ?>"><?php echo e(trans('global.app_add_new')); ?></button>
                    <?php else: ?>        
                    &nbsp;<a class="modalForm" data-action="createcustomer" data-selectedid="customer_id" data-toggle="tooltip" data-placement="bottom" data-original-subject="<?php echo e(trans('global.add_new_title', ['subject' => strtolower( trans('global.contracts.fields.customer') )])); ?>"><i class="fa fa-plus-square"></i></a>
                    <?php endif; ?>
                    <?php echo Form::select('customer_id', $customers, old('customer_id'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true','required'=>'']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('customer_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('customer_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                        <?php echo Form::label('currency_id', trans('global.recurring-invoices.fields.currency').'*', ['class' => 'control-label']); ?>

             <?php
                $currency_id = ! empty( old('currency_id_old') ) ? old('currency_id_old') : '';
                if ( empty( $currency_id ) && ! empty( $invoice ) ) {
                $currency_id = $invoice->currency_id;
                }
              ?>
                        <?php echo Form::select('currency_id', $currencies, old('currency_id',$currency_id), ['class' => 'form-control', 'required' => '','data-live-search' => 'true','data-show-subtext' => 'true','disabled' =>'']); ?>

                        <p class="help-block"></p>
                <input type="hidden" name="currency_id_old" id="currency_id_old" value="<?php echo e($currency_id); ?>">
                        <?php if($errors->has('currency_id')): ?>
                            <p class="help-block">
                                <?php echo e($errors->first('currency_id')); ?>

                            </p>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                        <?php echo Form::label('status', trans('global.recurring-invoices.fields.status').'', ['class' => 'control-label']); ?>

                        <?php echo Form::select('status', $enum_status, old('status'), ['class' => 'form-control select2']); ?>

                        <p class="help-block"></p>
                        <?php if($errors->has('status')): ?>
                            <p class="help-block">
                                <?php echo e($errors->first('status')); ?>

                            </p>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <?php echo Form::label('visible_to_customer', trans('global.contracts.fields.visible-to-customer').'', ['class' => 'control-label']); ?>

                <?php echo Form::select('visible_to_customer', $enum_visible_to_customer, old('visible_to_customer'), ['class' => 'form-control select2']); ?>

                <p class="help-block"></p>
                <?php if($errors->has('visible_to_customer')): ?>
                    <p class="help-block">
                        <?php echo e($errors->first('visible_to_customer')); ?>

                    </p>
                <?php endif; ?>
                </div>
                
            
                <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('address', trans('global.recurring-invoices.fields.address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('address', old('address'), ['class' => 'form-control ', 'placeholder' => 'Selected customer address', 'rows' => 4]); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-6">
                    <div class="form-group">
                       
                    <?php echo Form::label('delivery_address', trans('global.contracts.fields.show-delivery-address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('delivery_address', old('delivery_address'), ['class' => 'form-control ', 'placeholder' => trans('global.invoices.selected-customer-delivery-address'), 'rows' => 4, 'id' => 'delivery_address']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('delivery_address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('delivery_address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                    <div class="form-group">
                    <?php echo Form::label('show_delivery_address', trans('global.contracts.fields.show-delivery-address').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('show_delivery_address', yesnooptions(), old('show_delivery_address'), ['class' => 'form-control select2','data-live-search' => 'true','data-show-subtext' => 'true']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('show_delivery_address')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('show_delivery_address')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                   
                    <?php echo Form::label('subject', trans('global.contracts.fields.title').'', ['class' => 'control-label form-label']); ?>

                 <div class="form-line">
                    <?php echo Form::text('subject', old('subject'), ['class' => 'form-control', 'placeholder' => 'Subject','rows' => '4']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('subject')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('subject')); ?>

                        </p>
                    <?php endif; ?>
            </div>
                </div>
             </div>

          
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('invoice_prefix', trans('global.contracts.fields.contract-prefix').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('invoice_prefix', old('invoice_prefix'), ['class' => 'form-control', 'placeholder' => 'Invoice prefix']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_prefix')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_prefix')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('show_quantity_as', trans('global.recurring-invoices.fields.show-quantity-as').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('show_quantity_as', old('show_quantity_as'), ['class' => 'form-control', 'placeholder' => 'Show quantity as']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('show_quantity_as')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('show_quantity_as')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('invoice_no', trans('global.contracts.fields.contract-no'), ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('invoice_no', old('invoice_no'), ['class' => 'form-control', 'placeholder' => 'Enter contract number', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_no')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_no')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>
            
             
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('reference', trans('global.recurring-invoices.fields.reference').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('reference', old('reference'), ['class' => 'form-control', 'placeholder' => 'Reference']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('reference')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('reference')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
                </div>

                   
           
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                       
                    <?php echo Form::label('invoice_date', trans('global.contracts.fields.contract-date').'', ['class' => 'control-label']); ?>

                    <?php
                    $invoice_date = digiTodayDateAdd();
                    if ( ! empty( $recurring_invoice ) ) {
                    $invoice_date = ! empty( $recurring_invoice->invoice_date ) ?  digiDate($recurring_invoice->invoice_date)  : '';
                    }
                    ?>

                    <div class="form-line">
                    <?php echo Form::text('invoice_date', old('invoice_date', $invoice_date), ['class' => 'form-control date', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            
                <div class="col-xs-<?php echo e(COLUMNS); ?>">
                <div class="form-group">
                    <?php echo Form::label('invoice_due_date', trans('global.contracts.fields.contract-expiry-date').'', ['class' => 'control-label']); ?>

                    <div class="form-line">
                    <?php
                    $invoice_due_after = getSetting( 'contract_due_after', 'contract-settings', 2 );

                    $invoice_due_date = digiTodayDateAdd( $invoice_due_after );
                    if ( ! empty( $recurring_invoice ) ) {
                        $invoice_due_date = ! empty( $recurring_invoice->invoice_due_date ) ?  digiDate($recurring_invoice->invoice_due_date)  : '';
                    }
                    ?>
                    <?php echo Form::text('invoice_due_date', old('invoice_due_date', $invoice_due_date), ['class' => 'form-control date', 'placeholder' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_due_date')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_due_date')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
                 <div class="col-xs-6">
                  <div class="form-group">
                     <?php echo Form::label('contract_value', trans('global.contracts.fields.contract_value').'*', ['class' => 'control-label form-label']); ?>

                     <div class="form-line">
                        <?php echo Form::number('amount', old('amount'), ['class' => 'form-control amount', 'placeholder' => trans('global.contracts.fields.contract_value'), 'required' => '', 'min'=>'0','step'=>'0.01','id' => 'contract_value']); ?>

                        <p class="help-block"></p>
                        <?php if($errors->has('contract_value')): ?>
                        <p class="help-block">
                           <?php echo e($errors->first('contract_value')); ?>

                        </p>
                        <?php endif; ?>
                     </div>
                  </div>
                </div>
             

                   <div class="col-xs-6">
                  <div class="form-group">
                     <?php echo Form::label('contract_type_id', trans('global.contracts.fields.contract_type').'', ['class' => 'control-label']); ?>

                 
                     <?php echo Form::select('contract_type_id', $contract_types, old('contract_type_id'), ['class' => 'form-control select2', 'required' => '','data-live-search' => 'true','data-show-subtext' => 'true', 'subject' => trans('global.contracts.fields.contract_type')]); ?>

                     <p class="help-block"></p>
                     <?php if($errors->has('contract_type_id')): ?>
                     <p class="help-block">
                        <?php echo e($errors->first('contract_type_id')); ?>

                     </p>
                     <?php endif; ?>
                  </div>
               </div>
                <?php
                    $customer_id = old('customer_id');

                    if ( empty( $currency_id ) ) {
                        $currency_id = ! empty( $products_return->currency_id ) ? $products_return->currency_id : getDefaultCurrency('id');
                    }

                    $currency_code = getCurrency($currency_id, 'code');
                    $currency_symbol = getCurrency($currency_id, 'symbol');
                    ?>
                <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('invoice_notes', trans('global.contracts.fields.client-notes').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('invoice_notes', old('invoice_notes'), ['class' => 'form-control', 'placeholder' => 'Invoice notes']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('invoice_notes')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('invoice_notes')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-xs-6">
                <div class="form-group">
                    <?php echo Form::label('admin_notes', trans('global.invoices.fields.admin-notes').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('admin_notes', old('admin_notes'), ['class' => 'form-control', 'placeholder' => 'Admin notes']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('admin_notes')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('admin_notes')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>

                 <div class="col-xs-12">
                <div class="form-group">
                    <?php echo Form::label('terms_conditions', trans('global.invoices.fields.terms-conditions').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('terms_conditions', old('terms_conditions'), ['class' => 'form-control editor', 'placeholder' => 'Terms and conditions']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('terms_conditions')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('terms_conditions')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
   
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_update'), ['class' => 'btn btn-danger wave-effect']); ?>

    <?php echo Form::close(); ?>


    <?php echo $__env->make('admin.common.modal-loading-submit', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##
    <?php echo $__env->make('admin.common.standard-ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('admin.common.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php echo $__env->make('admin.common.modal-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/moment-with-locales.min.js')); ?>"></script>
    <script src="<?php echo e(url('adminlte/plugins/datetimepicker/bootstrap-datetimepicker.min.js')); ?>"></script>
    <script>
        $(function(){
            moment.updateLocale('<?php echo e(App::getLocale()); ?>', {
                week: { dow: 1 } // Monday is the first day of the week
            });
            
            $('.date').datetimepicker({
                format: "<?php echo e(config('app.date_format_moment')); ?>",
                locale: "<?php echo e(App::getLocale()); ?>",
            });
            
        });
    </script>
            
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>