<?php $request = app('Illuminate\Http\Request'); ?>


<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.invoices.invoice.invoice-menu', ['invoice' => $invoice], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.invoice-tasks.title'); ?></h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.invoice_tasks.create', $invoice->id)); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('global.app_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

                   

    <p>
        <ul class="list-inline">
                 <?php
                    $count = Modules\InvoiceAdditional\Entities\InvoiceTask::where('invoice_id', '=',$invoice->id )->count();
                    ?>
                    <li>
                        <a href="<?php echo e(route('admin.invoice_tasks.index', $invoice->id)); ?>"  style="<?php echo e(request('show_deleted') == 1 ? '' : 'font-weight: 700'); ?>"><?php echo app('translator')->getFromJson('global.app_all'); ?><span class="badge"><?php echo e($count); ?></span>
                        </a></li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_delete')): ?>
                        | 
                   <?php
                    $trash_count = Modules\InvoiceAdditional\Entities\InvoiceTask::where('invoice_id', '=',$invoice->id )->onlyTrashed()->count();
                    ?>          
             <li><a href="<?php echo e(route('admin.invoice_tasks.index', $invoice->id)); ?>?show_deleted=1" style="<?php echo e(request('show_deleted') == 1 ? 'font-weight: 700' : ''); ?>"><?php echo app('translator')->getFromJson('global.app_trash'); ?>
            <span class="badge"> 
               <?php echo e($trash_count); ?>

            </span>
            </a></li>
            <?php endif; ?>
        </ul>
    </p>


      
    

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_list'); ?>
        </div>

        <div class="panel-body table-responsive">
            <table class="table table-bordered table-striped ajaxTable <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_delete_multi')): ?> <?php if( request('show_deleted') != 1 ): ?> dt-select <?php endif; ?> <?php endif; ?>">
                <thead>
                    <tr>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_delete_multi')): ?>
                            <?php if( request('show_deleted') != 1 ): ?><th style="text-align:center;"><input type="checkbox" id="select-all" /></th><?php endif; ?>
                        <?php endif; ?>

                        <th><?php echo app('translator')->getFromJson('global.invoice-tasks.fields.name'); ?></th>
                     
                        <th><?php echo app('translator')->getFromJson('global.invoice-tasks.fields.startdate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.invoice-tasks.fields.duedate'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.invoice-tasks.fields.status'); ?></th>
                        <th><?php echo app('translator')->getFromJson('global.invoice-tasks.fields.assigned-to'); ?></th>
                    
                        <?php if( request('show_deleted') == 1 ): ?>
                        <th>&nbsp;</th>
                        <?php else: ?>
                        <th>&nbsp;</th>
                        <?php endif; ?>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?> 
    <script>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_delete_multi')): ?>
            <?php if( request('show_deleted') != 1 ): ?> window.route_mass_crud_entries_destroy = '<?php echo e(route('admin.invoice_tasks.mass_destroy')); ?>'; <?php endif; ?>
        <?php endif; ?>
        $(document).ready(function () {
            window.dtDefaultOptionsNew.ajax.url = '<?php echo route('admin.invoice_tasks.index', $invoice->id); ?>?show_deleted=<?php echo e(request('show_deleted')); ?>';
            window.dtDefaultOptionsNew.columns = [<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_task_delete_multi')): ?>
                <?php if( request('show_deleted') != 1 ): ?>
                    {data: 'massDelete', name: 'id', searchable: false, sortable: false},
                <?php endif; ?>
                <?php endif; ?>{data: 'name', name: 'name'},
            
                {data: 'startdate', name: 'startdate'},
                {data: 'duedate', name: 'duedate'},
                {data: 'status.title', name: 'status.title'},
                {data: 'assigned_to.name', name: 'assigned_to.name', sortable: false},
              
                
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ];
            processAjaxTablesNew();
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>