<?php $__env->startSection('content'); ?>
    <h3 class="page-title">
        <?php echo e($user->name); ?>

        <?php echo $__env->make('admin.common.drop-down-menu', [
        'links' => [
            [
                'route' => 'admin.users.edit', 
                'title' => trans('global.app_edit'), 
                'type' => 'edit',
                'icon' => '<i class="fa fa-pencil-square-o" style="margin-right: 15px;"></i>',
            ], 
            [
                'route' => 'admin.users.destroy', 
                'title' => trans('global.app_delete'), 
                'type' => 'delete',
                'icon' => '<i class="fa fa-trash-o" style="margin-right: 5px;color:#ff0000;padding-left: 20px;"></i>',
                'redirect_url' => url()->previous(),
            ],
        ],
        'record' => $user,
        ] , \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </h3>

    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_view'); ?>
        </div>
        <?php
    $tabs = [
        'details_active' => 'active',
        'user_actions_active'   => '',
        'internal_notifications_active' => '',
        'departments_active'    =>  '',
        'assets_history_active' =>  '',
        'tasks_active'           =>  '',
        'client_projects_active'=>  '',
        'support_active'        =>  '',
        'assets_active'         => '',
        'support_created_active'=> '',
        'invoices_active' => '',
        'recurring_invoices_active' => '',
        'quotes_active' => '',
        'recurring_invoices'=>'',
        'user_actions_active' => '',
        'proposals_active' => '',
        'contracts_active' => '',
    ];
    
    if ( ! empty( $list ) ) {
        foreach ($tabs as $key => $value) {
            $tabs[ $key ] = '';
            if ( substr( $key, 0, -7) == $list ) {
                $tabs[ $key ] = 'active';
            }
        }
    }
    ?>
        <!-- Nav tabs -->
<div class="panel-body table-responsive">
<ul class="nav nav-tabs" role="tablist">

<li role="presentation" class="<?php echo e($tabs['details_active']); ?>"><a href="#details" aria-controls="details" role="tab" data-toggle="tab"><?php echo app('translator')->getFromJson('others.canvas.details'); ?></a></li>
<li role="presentation" class="<?php echo e($tabs['user_actions_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'user_actions' ])); ?>" title="<?php echo app('translator')->getFromJson('global.user-actions.title'); ?>"><?php echo app('translator')->getFromJson('global.user-actions.title'); ?></a></li>
<?php if( isPluginActive('quick_notification') ): ?>
<li role="presentation" class="<?php echo e($tabs['internal_notifications_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'internal_notifications' ])); ?>" title="<?php echo app('translator')->getFromJson('others.canvas.notifications'); ?>"><?php echo app('translator')->getFromJson('others.canvas.notifications'); ?></a></li>
<?php endif; ?>
<li role="presentation" class="<?php echo e($tabs['departments_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'departments' ])); ?>" title="<?php echo app('translator')->getFromJson('global.departments.title'); ?>"><?php echo app('translator')->getFromJson('global.departments.title'); ?></a></li>
<?php if( isPluginActive('asset') ): ?>
<li role="presentation" class="<?php echo e($tabs['assets_history_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'assets_history' ])); ?>" title="<?php echo app('translator')->getFromJson('global.assets-history.title'); ?>"><?php echo app('translator')->getFromJson('global.assets-history.title'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive('task') ): ?>
<li role="presentation" class="<?php echo e($tabs['tasks_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'tasks' ])); ?>" title="<?php echo app('translator')->getFromJson('global.tasks.title'); ?>"><?php echo app('translator')->getFromJson('global.tasks.title'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive('client_project') ): ?>
<li role="presentation" class="<?php echo e($tabs['client_projects_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'client_projects' ])); ?>" title="<?php echo app('translator')->getFromJson('global.client-projects.title'); ?>"><?php echo app('translator')->getFromJson('global.client-projects.title'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive( 'support' ) ): ?>
<li role="presentation" class="<?php echo e($tabs['support_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'support' ])); ?>" title="<?php echo app('translator')->getFromJson('global.support.title'); ?>"><?php echo app('translator')->getFromJson('global.support.title'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive('asset') ): ?>
<li role="presentation" class="<?php echo e($tabs['assets_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'assets' ])); ?>" title="<?php echo app('translator')->getFromJson('global.assets.title'); ?>"><?php echo app('translator')->getFromJson('global.assets.title'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive( ['support', 'faq'] ) ): ?>
<li role="presentation" class="<?php echo e($tabs['support_created_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'support_created' ])); ?>" title="<?php echo app('translator')->getFromJson('others.canvas.support-created'); ?>"><?php echo app('translator')->getFromJson('others.canvas.support-created'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive( 'invoice' ) ): ?>
<li role="presentation" class="<?php echo e($tabs['invoices_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'invoices' ])); ?>" title="<?php echo app('translator')->getFromJson('others.canvas.invoices'); ?>"><?php echo app('translator')->getFromJson('others.canvas.invoices'); ?></a></li>
<?php endif; ?>
<?php if( isPluginActive( ['quotes'] ) ): ?>
<li role="presentation" class="<?php echo e($tabs['quotes_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'quotes' ])); ?>" title="<?php echo app('translator')->getFromJson('global.quotes.title'); ?>"><?php echo app('translator')->getFromJson('global.quotes.title'); ?></a></li>
<?php endif; ?>
<?php if( File::exists(config('modules.paths.modules') . '/RecurringInvoices') && Module::find('recurringinvoices')->active && isPluginActive('recurringinvoices')): ?>
<li role="presentation" class="<?php echo e($tabs['recurring_invoices_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'recurring_invoices' ])); ?>" title="<?php echo app('translator')->getFromJson('global.recurring-invoices.title'); ?>"><?php echo app('translator')->getFromJson('global.recurring-invoices.title'); ?></a></li>
<?php endif; ?>
<?php if( File::exists(config('modules.paths.modules') . '/Proposals') && Module::find('proposals')->active && isPluginActive('proposals')): ?>
        <li role="presentation" class="<?php echo e($tabs['proposals_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'proposals' ])); ?>">
<?php echo app('translator')->getFromJson('proposals::global.proposals.title'); ?></a></li>
<?php endif; ?>
<?php if( File::exists(config('modules.paths.modules') . '/Contracts') && Module::find('contracts')->active && isPluginActive('contracts')): ?>
            <li role="presentation" class="<?php echo e($tabs['contracts_active']); ?>"><a href="<?php echo e(route('admin.users.show', [ 'user_id' => $user->id, 'list' => 'contracts' ])); ?>"><?php echo app('translator')->getFromJson('contracts::global.contracts.title'); ?></a></li>
<?php endif; ?>  
</ul>

<!-- Tab panes -->
<div class="tab-content">

 <div role="tabpanel" class="tab-pane <?php echo e($tabs['details_active']); ?>" id="details">

        <div class="pull-right">
          <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_edit')): ?>
            <a href="<?php echo e(route('admin.users.edit',[ $user->id ])); ?>" class="btn btn-xs btn-info"><i class="fa fa-pencil-square-o"></i><?php echo app('translator')->getFromJson('global.app_edit'); ?></a>
          <?php endif; ?>
        </div> 

        <table class="table1 table-bordered table-striped">
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.users.fields.name'); ?></th>
                            <td field-key='name'><?php echo e($user->name); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.users.fields.email'); ?></th>
                            <td field-key='email'><?php echo e($user->email); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.users.fields.role'); ?></th>
                            <td field-key='role'>
                                <?php $__currentLoopData = $user->role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleRole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="label label-info label-many"><?php echo e($singleRole->title); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        
                        <tr>
                            <th><?php echo app('translator')->getFromJson('global.users.fields.department'); ?></th>
                            <td field-key='department'><?php echo e($user->department->name ?? ''); ?></td>
                        </tr>
                       
                        <tr>
                            <th><?php echo app('translator')->getFromJson('others.users.is-support-admin'); ?></th>
                            <td field-key='department'><?php echo e($user->ticketit_admin == 0  ? 'No' : 'Yes'); ?></td>
                        </tr>
                        <tr>
                          <th><?php echo app('translator')->getFromJson('others.users.is-support-agent'); ?></th>
                          <td field-key='department'><?php echo e($user->ticketit_agent == 0 ? 'No' : 'Yes'); ?></td>
                        </tr>
                    </table>

    </div>    
    
<?php if( 'active' === $tabs['user_actions_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['user_actions_active']); ?>" id="user_actions">
    <?php echo $__env->make('admin.user_actions.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['internal_notifications_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['internal_notifications_active']); ?>" id="internal_notifications">
    <?php echo $__env->make('admin.internal_notifications.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['departments_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['departments_active']); ?>" id="departments">
    <?php echo $__env->make('admin.departments.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['assets_history_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['assets_history_active']); ?>" id="assets_history">
    <?php echo $__env->make('admin.assets_histories.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['tasks_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['tasks_active']); ?>" id="tasks">
    <?php echo $__env->make('admin.tasks.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['client_projects_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['client_projects_active']); ?>" id="client_projects">
    <?php echo $__env->make('admin.client_projects.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['support_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['support_active']); ?>" id="support">
    <?php echo $__env->make('ticketit::tickets.partials.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['assets_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['assets_active']); ?>" id="assets">
    <?php echo $__env->make('admin.assets.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['support_created_active']): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['support_created_active']); ?>" id="support_created">
    <?php echo $__env->make('ticketit::tickets.partials.datatable', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['invoices_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['invoices_active']); ?>" id="invoices">
    <?php echo $__env->make('admin.invoices.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>

<?php if( 'active' === $tabs['quotes_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['quotes_active']); ?>" id="quotes">
    <?php echo $__env->make('quotes::admin.quotes.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>

<?php if( 'active' === $tabs['recurring_invoices_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['recurring_invoices_active']); ?>" id="recurring_invoices">
    <?php echo $__env->make('recurringinvoices::admin.recurring_invoices.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>
<?php if( 'active' === $tabs['proposals_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['proposals_active']); ?>" id="proposals">
    <?php echo $__env->make('proposals::admin.proposals.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>

<?php if( 'active' === $tabs['contracts_active'] ): ?>
<div role="tabpanel" class="tab-pane <?php echo e($tabs['contracts_active']); ?>" id="contracts">
    <?php echo $__env->make('contracts::admin.contracts.records-display', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</div>
<?php endif; ?>

</div>

            <p>&nbsp;</p>

            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-default"><?php echo app('translator')->getFromJson('global.app_back_to_list'); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?> 

    <?php if( 'active' === $tabs['user_actions_active'] ): ?>
        <?php echo $__env->make('admin.user_actions.records-display-scripts', [ 'type' => 'user', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>  
    <?php if( 'active' === $tabs['internal_notifications_active'] ): ?>
        <?php echo $__env->make('admin.internal_notifications.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>  
    <?php if( 'active' === $tabs['departments_active'] ): ?>
        <?php echo $__env->make('admin.departments.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>  
    <?php if( 'active' === $tabs['assets_history_active'] ): ?>
        <?php echo $__env->make('admin.assets_histories.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>  
    <?php if( 'active' === $tabs['tasks_active'] ): ?>
        <?php echo $__env->make('admin.tasks.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?> 
    <?php if( 'active' === $tabs['client_projects_active'] ): ?>
        <?php echo $__env->make('admin.client_projects.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?> 
    <?php if( 'active' === $tabs['support_active'] ): ?>
        <?php echo $__env->make('ticketit::tickets.partials.datatable-scripts', [ 'type' => 'agent', 'type_id' => $user->id, 'complete' => false ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?> 
    <?php if( 'active' === $tabs['assets_active'] ): ?>
        <?php echo $__env->make('admin.assets.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['support_created_active'] ): ?>
        <?php echo $__env->make('ticketit::tickets.partials.datatable-scripts', [ 'type' => 'usersupportcreated', 'type_id' => $user->id, 'complete' => false ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['invoices_active'] ): ?>
        <?php echo $__env->make('admin.invoices.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['quotes_active'] ): ?>
        <?php echo $__env->make('quotes::admin.quotes.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['recurring_invoices_active'] ): ?>
        <?php echo $__env->make('recurringinvoices::admin.recurring_invoices.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['proposals_active'] ): ?>
        <?php echo $__env->make('proposals::admin.proposals.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    <?php if( 'active' === $tabs['contracts_active'] ): ?>
        <?php echo $__env->make('contracts::admin.contracts.records-display-scripts', [ 'type' => 'contact', 'type_id' => $user->id ], \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <?php endif; ?>
    
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>