<script src="//cdn.datatables.net/v/bs/dt-<?php echo e(Kordy\Ticketit\Helpers\Cdn::DataTables); ?>/r-<?php echo e(Kordy\Ticketit\Helpers\Cdn::DataTablesResponsive); ?>/datatables.min.js"></script>
<?php
$type = ! empty( $type ) ? $type : '';
$type_id = ! empty( $type_id ) ? $type_id : '';
$complete = ! empty( $complete ) ? $complete : '0';
?>
<script>
    $('.table').DataTable({
        processing: false,
        serverSide: true,
        responsive: true,
        pageLength: <?php echo e($setting->grab('paginate_items')); ?>,
    	lengthMenu: <?php echo e(json_encode($setting->grab('length_menu'))); ?>,
        ajax: '<?php echo route($setting->grab('main_route').'.data', [ 'complete' => $complete, 'type' => $type, 'type_id' => $type_id ] ); ?>',
        language: {
			decimal:        "<?php echo e(trans('ticketit::lang.table-decimal')); ?>",
			emptyTable:     "<?php echo e(trans('ticketit::lang.table-empty')); ?>",
			info:           "<?php echo e(trans('ticketit::lang.table-info')); ?>",
			infoEmpty:      "<?php echo e(trans('ticketit::lang.table-info-empty')); ?>",
			infoFiltered:   "<?php echo e(trans('ticketit::lang.table-info-filtered')); ?>",
			infoPostFix:    "<?php echo e(trans('ticketit::lang.table-info-postfix')); ?>",
			thousands:      "<?php echo e(trans('ticketit::lang.table-thousands')); ?>",
			lengthMenu:     "<?php echo e(trans('ticketit::lang.table-length-menu')); ?>",
			loadingRecords: "<?php echo e(trans('ticketit::lang.table-loading-results')); ?>",
			processing:     "<?php echo e(trans('ticketit::lang.table-processing')); ?>",
			search:         "<?php echo e(trans('ticketit::lang.table-search')); ?>",
			zeroRecords:    "<?php echo e(trans('ticketit::lang.table-zero-records')); ?>",
			paginate: {
				first:      "<?php echo e(trans('ticketit::lang.table-paginate-first')); ?>",
				last:       "<?php echo e(trans('ticketit::lang.table-paginate-last')); ?>",
				next:       "<?php echo e(trans('ticketit::lang.table-paginate-next')); ?>",
				previous:   "<?php echo e(trans('ticketit::lang.table-paginate-prev')); ?>"
			},
			aria: {
				sortAscending:  "<?php echo e(trans('ticketit::lang.table-aria-sort-asc')); ?>",
				sortDescending: "<?php echo e(trans('ticketit::lang.table-aria-sort-desc')); ?>"
			},
		},
        columns: [
            { data: 'id', name: 'ticketit.id' },
            { data: 'subject', name: 'subject' },
            { data: 'status', name: 'ticketit_statuses.name' },
            { data: 'updated_at', name: 'ticketit.updated_at' },
        	{ data: 'agent', name: 'contacts.name' },
            <?php if( $u->isAgent() || $u->isAdmin() ): ?>
	            { data: 'priority', name: 'ticketit_priorities.name' },
            	{ data: 'owner', name: 'contacts.name' },
	            { data: 'category', name: 'ticketit_categories.name' }
            <?php endif; ?>
        ]
    });
</script>