<?php $__env->startSection('content'); ?>
    <h3 class="page-title"><?php echo app('translator')->getFromJson('global.assets.title'); ?></h3>
    <?php echo Form::open(['method' => 'POST', 'route' => ['admin.assets.store'], 'files' => true,'class'=>'formvalidation']); ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <?php echo app('translator')->getFromJson('global.app_create'); ?>
        </div>
        
        <div class="panel-body">
            <div class="row">
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('category_id', trans('global.assets.fields.category').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::select('category_id', $categories, old('category_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('category_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('category_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    
                    <?php echo Form::label('serial_number', trans('global.assets.fields.serial-number').'', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('serial_number', old('serial_number'), ['class' => 'form-control', 'placeholder' => 'Serial number']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('serial_number')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('serial_number')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    
                    <?php echo Form::label('title', trans('global.assets.fields.title').'*', ['class' => 'control-label form-label']); ?>

                    <div class="form-line">
                    <?php echo Form::text('title', old('title'), ['class' => 'form-control', 'placeholder' => 'Title', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('title')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('title')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
                </div>
            </div>
                <div class="row">
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('photo1', trans('global.assets.fields.photo1').'', ['class' => 'control-label']); ?>

                    <?php echo Form::file('photo1', ['class' => 'form-control', 'style' => 'margin-top: 4px;']); ?>

                    <?php echo Form::hidden('photo1_max_size', 8); ?>

                    <?php echo Form::hidden('photo1_max_width', 6000); ?>

                    <?php echo Form::hidden('photo1_max_height', 6000); ?>

                    <p class="help-block"><?php echo e(trans('others.global_file_types_gallery')); ?></p>
                    <?php if($errors->has('photo1')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('photo1')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('photo2', trans('global.assets.fields.photo2').'', ['class' => 'control-label']); ?>

                    <?php echo Form::file('photo2[]', [
                        'multiple',
                        'class' => 'form-control file-upload',
                        'data-url' => route('admin.media.upload'),
                        'data-bucket' => 'photo2',
                        'data-filekey' => 'photo2',
                        'data-accept' => FILE_TYPES_GALLERY,
                        ]); ?>

                    <p class="help-block"><?php echo e(trans('others.global_file_types_gallery')); ?></p>
                    <div class="photo-block">
                        <div class="progress-bar">&nbsp;</div>
                        <div class="files-list"></div>
                    </div>
                    <?php if($errors->has('photo2')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('photo2')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('attachments', trans('global.assets.fields.attachments').'', ['class' => 'control-label']); ?>

                    <?php echo Form::file('attachments[]', [
                        'multiple',
                        'class' => 'form-control file-upload',
                        'data-url' => route('admin.media.upload'),
                        'data-bucket' => 'attachments',
                        'data-filekey' => 'attachments',
                        'data-accept' => FILE_TYPES_GENERAL,
                        ]); ?>

                    <p class="help-block"><?php echo e(trans('others.global_file_types_general')); ?></p>
                    <div class="photo-block">
                        <div class="progress-bar">&nbsp;</div>
                        <div class="files-list"></div>
                    </div>
                    <?php if($errors->has('attachments')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('attachments')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            </div>

            <div class="row">
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('status_id', trans('global.assets.fields.status').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::select('status_id', $statuses, old('status_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('status_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('status_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    <?php echo Form::label('location_id', trans('global.assets.fields.location').'*', ['class' => 'control-label']); ?>

                    <?php echo Form::select('location_id', $locations, old('location_id'), ['class' => 'form-control select2', 'required' => '']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('location_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('location_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-4">
                <div class="form-group">
                    
                    <?php echo Form::label('assigned_user_id', trans('global.assets.fields.assigned-user').'', ['class' => 'control-label']); ?>

                    <?php echo Form::select('assigned_user_id', $assigned_users, old('assigned_user_id'), ['class' => 'form-control select2']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('assigned_user_id')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('assigned_user_id')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            
                <div class="col-xs-6">
                <div class="form-group">
                    
                    <?php echo Form::label('notes', trans('global.assets.fields.notes').'', ['class' => 'control-label']); ?>

                    <?php echo Form::textarea('notes', old('notes'), ['class' => 'form-control ', 'placeholder' => 'Notes','rows'=>'3']); ?>

                    <p class="help-block"></p>
                    <?php if($errors->has('notes')): ?>
                        <p class="help-block">
                            <?php echo e($errors->first('notes')); ?>

                        </p>
                    <?php endif; ?>
                </div>
                </div>
            </div>
            
        </div>
    </div>

    <?php echo Form::submit(trans('global.app_save'), ['class' => 'btn btn-danger wave-effect']); ?>

    <?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    ##parent-placeholder-b6e13ad53d8ec41b034c49f131c64e99cf25207a##

    <script src="<?php echo e(asset('adminlte/plugins/fileUpload/js/jquery.iframe-transport.js')); ?>"></script>
    <script src="<?php echo e(asset('adminlte/plugins/fileUpload/js/jquery.fileupload.js')); ?>"></script>
    <script>
        $(function () {
            $('.file-upload').each(function () {
                var $this = $(this);
                var $parent = $(this).parent();

                $(this).fileupload({
                    dataType: 'json',
                    formData: {
                        model_name: 'Asset',
                        bucket: $this.data('bucket'),
                        file_key: $this.data('filekey'),
                        accept: $this.data('accept'),
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    add: function (e, data) {
                        data.submit();
                    },
                    done: function (e, data) {
                        $.each(data.result.files, function (index, file) {
                            if ( file.size > 0 ) {
                            var $line = $($('<p/>', {class: "form-group"}).html(file.name + ' (' + file.size + ' bytes)').appendTo($parent.find('.files-list')));
                            $line.append('<a href="#" class="btn btn-xs btn-danger remove-file">Remove</a>');
                            $line.append('<input type="hidden" name="' + $this.data('bucket') + '_id[]" value="' + file.id + '"/>');
                            if ($parent.find('.' + $this.data('bucket') + '-ids').val() != '') {
                                $parent.find('.' + $this.data('bucket') + '-ids').val($parent.find('.' + $this.data('bucket') + '-ids').val() + ',');
                            }
                            $parent.find('.' + $this.data('bucket') + '-ids').val($parent.find('.' + $this.data('bucket') + '-ids').val() + file.id);
                            } else {
                                var $line = $($('<p/>', {class: "form-group"}).html(file.name).appendTo($parent.find('.files-list')));
                                $line.append('<a href="#" class="btn btn-xs btn-danger remove-file">Not accepted</a>');
                            }
                        });
                        $parent.find('.progress-bar').hide().css(
                            'width',
                            '0%'
                        );
                    }
                }).on('fileuploadprogressall', function (e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $parent.find('.progress-bar').show().css(
                        'width',
                        progress + '%'
                    );
                });
            });
            $(document).on('click', '.remove-file', function () {
                var $parent = $(this).parent();
                $parent.remove();
                return false;
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>