<?php
$transactions = $invoice->transactions();
if ( $transactions->count() > 0 ) {
?>
<div id="invoice-template">
<h3><?php echo app('translator')->getFromJson('custom.invoices.related-transactions'); ?></h3>
    <table class="table table-bordered sys_table">
        <tbody>
            <tr>
                <th><?php echo app('translator')->getFromJson('custom.invoices.date'); ?></th>
                <th>Account</th>
                <th class="text-right"><?php echo app('translator')->getFromJson('custom.invoices.amount'); ?></th>
                <th><?php echo app('translator')->getFromJson('custom.invoices.description'); ?></th>
				<th><?php echo app('translator')->getFromJson('global.recurring-invoices.fields.status'); ?></th>
            </tr>
            <?php $__currentLoopData = $transactions->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
			
            $account = $transaction->account()->where('id', '=', $transaction->account_id)->first();
            $account_name = ! empty( $account ) ? $account->name : '';
            ?>
            <tr class="info">
                <td><?php echo e(digiDate( $transaction->created_at, true )); ?></td>
                <td><?php echo e($account_name); ?></td>
                <td class="text-right amount"><?php echo e(digiCurrency( $transaction->amount,$invoice->currency_id )); ?></td>
                <td><?php echo e($transaction->description); ?></td>
				<td><?php echo e($transaction->payment_status ?? $transaction->payment_status); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </tbody></table>
</div>
<?php } ?>